<?php $__env->startSection('content'); ?>
<div class="content-wrapper">
	<div class="content pt-3">
		<div class="container-fluid">
			<div class="row">
				<div class="col-12">
					<div class="card border-0 shadow-custom">
						<div class="card-header border-grey">
							<h3 class="card-title">
								<?php echo e(__('reports.info_title')); ?>

							</h3>
						</div>
						<div class="card-body">
							<div class="row">
								<div class="col-md-12 d-flex justify-content-between">
									<div class="report-btns">
										<a href="<?php echo e(route('reports.member_information', ['type' => 'csv'] )); ?>"
											class="btn btn-default"><i class="fas fa-file-csv"></i> <?php echo e(__('reports.export')); ?></a>
										<a href="<?php echo e(route('reports.member_information', ['type' => 'print'] )); ?>"
											rel="noopener" target="_blank" class="btn btn-default"><i
												class="fas fa-print"></i> <?php echo e(__('reports.print')); ?></a>
									</div>
									<form class="w-25" method="post" action="<?php echo e(route('reports.member_information')); ?>">
										<?php echo e(csrf_field()); ?>

										<div class="input-group mb-3">
											<select class="form-control " name="search" required>
												<option value="all" <?php echo e($keyword=="all" ? "selected" : ""); ?>>
													All Status
												</option>
												<option value="valid" <?php echo e($keyword=="valid" ? "selected" : ""); ?>>
													Valid
												</option>
												<option value="expired" <?php echo e($keyword=="expired" ? "selected" : ""); ?>>
													Expired
												</option>
												<option value="near_expiry" <?php echo e($keyword=="near_expiry" ? "selected" : ""); ?>>
													Near Expiry
												</option>
											</select>
											<div class="input-group-append">
												<button class="btn btn-primary" type="submit"><i
														class="fas fa-search"></i></button>
											</div>
										</div>
									</form>
								</div>
								<div class="col-12">
									<div class="table-responsive">
										<table class="table custom-table-bordered table-hover">
											<thead>
												<tr>
													<th class="nowrap"><?php echo e(__('reports.th_reg_no')); ?></th>
													<th><?php echo e(__('reports.th_member_name')); ?></th>
													<th><?php echo e(__('reports.th_phone')); ?></th>
													<th class="nowrap"><?php echo e(__('reports.th_membership_type')); ?></th>
													<th class="nowrap"><?php echo e(__('reports.th_valid_from')); ?></th>
													<th class="nowrap"><?php echo e(__('reports.th_valid_to')); ?></th>
													<th class="nowrap fixed-width-td"><?php echo e(__('reports.th_status')); ?></th>
												</tr>
											</thead>
											<tbody>
												<?php $__currentLoopData = $members; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $member): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
												<tr>
													<td class="align-middle"><?php echo e($member->reg_no); ?></td>
													<td class="align-middle nowrap"><?php echo e($member->name); ?></td>
													<td class="align-middle"><?php echo e($member->phone); ?></td>
													<td class="align-middle nowrap"><?php echo e($member->membership_name); ?></td>
													<td class="align-middle nowrap"><?php echo e(format_date($member->valid_from)); ?></td>
													<td class="align-middle nowrap"><?php echo e(format_date($member->valid_to)); ?>

													</td>
													<td class="align-middle nowrap"><?php echo membership_status($member->valid_to); ?></td>
												</tr>
												<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
												<?php if(count($members) == 0): ?>
												<tr>
													<td colspan="11">
														<p class="text-center mb-0"><?php echo e(__('reports.no_record_found')); ?>

														</p>
													</td>
												</tr>
												<?php endif; ?>
											</tbody>
										</table>
									</div>
								</div>
								<div class="col-12">
									<div class="d-flex justify-content-end">
										<?php if($paginate): ?>
										<?php echo e($members->links()); ?>

										<?php endif; ?>
									</div>
								</div>
							</div>
						</div>
					</div>
				</div>
			</div>
		</div>
	</div>
</div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/resources/views/reports/member_information.blade.php ENDPATH**/ ?>